<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service\Predis;

use IssetBV\CacheBundle\Service\Core\CacheClient;
use Predis\Client;

/**
 * Class PredisCacheClient.
 */
class PredisCacheClient implements CacheClient
{
    /**
     * @var Client
     */
    private $client;

    /**
     * PredisCacheClient constructor.
     *
     * @param string $host
     * @param int $port
     */
    public function __construct(string $host = 'localhost', int $port = 6379)
    {
        $this->client = new Client([
            'host' => $host,
            'port' => $port,
        ]);
    }

    public function get(string $key)
    {
        return $this->client->get($key);
    }

    public function set(string $key, $value)
    {
        $this->client->set($key, $value);
    }

    public function delete(string $key)
    {
        $this->client->del([$key]);
    }

    public function flushAll()
    {
        $this->client->flushall();
    }
}
