<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service\Factory;

use IssetBV\CacheBundle\Service\Core\CacheClient;

class CacheFactoryClientItem
{
    /**
     * @var string
     */
    private $name;
    /**
     * @var CacheClient
     */
    private $cacheClient;

    public function __construct(String $name, CacheClient $cacheClient)
    {
        $this->name = $name;
        $this->cacheClient = $cacheClient;
    }

    /**
     * @return string
     */
    public function getName(): String
    {
        return $this->name;
    }

    /**
     * @return CacheClient
     */
    public function getCacheClient(): CacheClient
    {
        return $this->cacheClient;
    }
}
