<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service\Factory;

use IssetBV\CacheBundle\Service\Core\CacheClient;

class CacheFactoryClient implements CacheClient
{
    /**
     * @var CacheFactory
     */
    private $cacheFactory;
    /**
     * @var string
     */
    private $connection;

    /**
     * @var CacheClient
     */
    private $cacheClient;

    /**
     * FactoryCacheClient constructor.
     *
     * @param CacheFactory $cacheFactory
     * @param string $connection
     */
    public function __construct(CacheFactory $cacheFactory, string $connection)
    {
        $this->cacheFactory = $cacheFactory;
        $this->connection = $connection;
    }

    public function get(string $key)
    {
        return $this->getCacheClient()->get($key);
    }

    public function set(string $key, $value)
    {
        $this->getCacheClient()->set($key, $value);
    }

    public function delete(string $key)
    {
        $this->getCacheClient()->delete($key);
    }

    public function flushAll()
    {
        $this->getCacheClient()->flushAll();
    }

    private function getCacheClient(): CacheClient
    {
        if ($this->cacheClient === null) {
            $this->cacheClient = $this->cacheFactory->getCacheClientByName($this->connection);
        }

        return $this->cacheClient;
    }
}
