<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Service\Factory;

use IssetBV\CacheBundle\Service\Core\CacheClient;
use LogicException;

/**
 * Class CacheFactory.
 */
class CacheFactory
{
    /**
     * @var CacheClient[]
     */
    private $cacheClients = [];

    /**
     * @param string $clientName
     *
     * @return CacheClient
     */
    public function getCacheClientByName(string $clientName): CacheClient
    {
        if (!array_key_exists($clientName, $this->cacheClients)) {
            throw new LogicException('unknown client name: ' . $clientName);
        }

        return $this->cacheClients[$clientName];
    }

    /**
     * @param CacheFactoryClientItem $cacheFactoryClientItem
     */
    public function add(CacheFactoryClientItem $cacheFactoryClientItem)
    {
        $this->cacheClients[$cacheFactoryClientItem->getName()] = $cacheFactoryClientItem->getCacheClient();
    }
}
