<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\DependencyInjection;

use IssetBV\CacheBundle\Service\Factory\CacheFactoryClientItem;
use IssetBV\CacheBundle\Service\Predis\PredisCacheClient;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\DependencyInjection\Reference;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @see http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVCacheExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if (array_key_exists('predis', $config)) {
            $this->handlePredis($container, $config['predis']);
        }
    }

    private function handlePredis(ContainerBuilder $container, array $config)
    {
        foreach ($config as $clientName => $clientData) {
            $this->createPredis($container, $clientName, $clientData);
        }
    }

    private function createPredis(ContainerBuilder $container, string $clientName, array $config)
    {
        $clientKey = 'isset_bv.cache.client.' . $clientName;
        $definition = $container->register($clientKey, PredisCacheClient::class);
        $definition->addArgument($config['host']);
        $definition->addArgument($config['port']);
        $definition->setLazy(true);
        $this->createFactoryElement($container, $clientName, $clientKey);
    }

    private function createFactoryElement(ContainerBuilder $container, string $clientName, string $clientKey)
    {
        $definition = $container->register('isset_bv.cache.client.factory.item.' . $clientName, CacheFactoryClientItem::class);
        $definition->addArgument($clientName);
        $definition->addArgument(new Reference($clientKey));
        $definition->addTag('isset_bv.cache.client.factory.item');
    }
}
