<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\Predis\PredisCacheClient;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CacheSetCommand.
 */
class CacheSetCommand extends ContainerAwareCommand
{
    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('isset:cache:set');
        $this->addArgument('key', InputArgument::REQUIRED, 'cache key to set');
        $this->addArgument('value', InputArgument::REQUIRED, 'cache value to set');
        $this->addOption(
            'connection',
            'c',
            InputOption::VALUE_OPTIONAL
        );
        $this->setDescription('set cache item');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $client = new PredisCacheClient();
        $client->set($input->getArgument('key'), $input->getArgument('value'));
    }
}
