<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\Predis\PredisCacheClient;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CacheGetCommand.
 */
class CacheGetCommand extends ContainerAwareCommand
{
    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('isset:cache:get');
        $this->addArgument('key', InputArgument::REQUIRED, 'cache key to delete');
        $this->addOption(
            'connection',
            'c',
            InputOption::VALUE_OPTIONAL
        );
        $this->setDescription('delete cache item');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $client = new PredisCacheClient();
        $data = $client->get($input->getArgument('key'));
        if ($data === null) {
            $output->writeln('<error>Null</error>');
        } else {
            $output->writeln($data);
        }
    }
}
