<?php

declare(strict_types=1);

namespace IssetBV\CacheBundle\Command;

use IssetBV\CacheBundle\Service\Predis\PredisCacheClient;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CacheFlushAllCommand.
 */
class CacheFlushAllCommand extends ContainerAwareCommand
{
    /**
     * @throws \Symfony\Component\Console\Exception\InvalidArgumentException
     */
    protected function configure()
    {
        $this->setName('isset:cache:flush_all');
        $this->addOption(
            'connection',
            'c',
            InputOption::VALUE_OPTIONAL
        );
        $this->setDescription('delete all items from cache');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     *
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $client = new PredisCacheClient();
        $client->flushAll();
    }
}
