<?php

namespace IssetBv\CacheBundle\Framework;

class Core
{

    /**
     * @var \IssetBv\CacheBundle\Framework\Adapter\Adapter
     */
    private $adapter;
    private $container = array();

    public function __construct($adapter)
    {

        if ($adapter instanceof \IssetBv\CacheBundle\Framework\Adapter\Adapter) {
            $this->adapter = $adapter;
        } else {
            $this->adapter = new $adapter['class']($adapter['arguments']);
        }
    }

    /**
     *
     * @param String $namespace
     * @return \IssetBv\CacheBundle\Framework\Container
     */
    public function getContainerByNamespace($namespace)
    {
        if (!isset($this->container[$namespace])) {
            $this->container[$namespace] = new Container($this->adapter, $namespace);
        }
        return $this->container[$namespace];
    }

    public function flush()
    {
        return $this->adapter->flush();
    }

    /**
     * @return \IssetBv\CacheBundle\Framework\Adapter\Adapter
     */
    public function getAdapter()
    {
        return $this->adapter;
    }

}