<?php

namespace IssetBv\CacheBundle\Framework;

class ContainerItem
{

    private $key;
    private $value;
    private $flushed;
    private $fetched;

    public function __construct($key, $value, $fetched = false, $flushed = false)
    {
        $this->key     = $key;
        $this->value   = $value;
        $this->flushed = $flushed;
        $this->fetched = $fetched;
    }

    public function getKey()
    {
        return $this->key;
    }

    public function setValue($value)
    {
        if ($this->value == $value) {
            return true;
        }

        $this->value   = $value;
        $this->flushed = false;
        return true;
    }

    public function getValue()
    {
        return $this->value;
    }

    public function isFlushed()
    {
        return (bool) $this->flushed;
    }

    public function setFlushed($isFlushed)
    {
        $this->flushed = (bool) $isFlushed;
    }

    public function isFetched()
    {
        return (bool) $this->fetched;
    }

    public function setFetched($isFetched)
    {
        $this->fetched = (bool) $isFetched;
    }

}