<?php

namespace IssetBv\CacheBundle\Framework;

class Container
{

    /**
     * @var \IssetBv\CacheBundle\Framework\Adapter\Adapter
     */
    private $adapter;
    private $namespace;
    private $items = array();
    private $want = array();

    public function __construct(Adapter\Adapter $adapter, $namespace)
    {
        $this->adapter   = $adapter;
        $this->namespace = $namespace;
    }

    public function add($key, $value, $flush = false)
    {
        if (empty($this->items[$key])) {
            $this->items[$key] = new ContainerItem($key, $value);
        } else {
            $this->items[$key]->setValue($value);
        }
        
        if ($flush) {
            $this->flush();
        }
    }

    public function get($key)
    {
        if (!isset($this->items[$key])) {
            $value = $this->adapter->get($this->getAdapterKey($key));
            if ($value) {
                $this->items[$key] = new ContainerItem($key, $value, true, true);
            }
        }

        if (isset($this->items[$key]) && $this->items[$key]) {
            return $this->items[$key]->getValue();
        }

        return false;
    }

    public function delete($key)
    {
        return $this->adapter->delete($this->getAdapterKey($key));
    }

    public function want($key)
    {
        if (isset($this->items[$key])) {
            return true;
        }
        $key = $this->getAdapterKey($key);
        if (!in_array($key, $this->want)) {
            $this->want[] = $key;
        }

        return true;
    }

    public function fetch()
    {
        if (empty($this->want)) {
            return true;
        }
        $fetched = $this->adapter->getMulti($this->want);
        foreach ($this->want as $adapterKey) {
            $key = $this->getKeyFromAdapterKey($adapterKey);
            if (isset($fetched[$adapterKey])) {
                $this->items[$key] = new ContainerItem($key, $fetched[$adapterKey], true, true);
            } else {
                $this->items[$key] = false;
            }
        }

        $this->want = array();
        return true;
    }

    public function flush()
    {
        $flushItems = array();
        foreach ($this->items as $item) {
            /* @var $item \IssetBv\CacheBundle\Framework\ContainerItem */
            if (!$item->isFlushed()) {
                $flushItems[$this->getAdapterKey($item->getKey())] = $item->getValue();
                $item->setFlushed(true);
            }
        }

        if (empty($flushItems)) {
            return true;
        }

        return $this->adapter->setMulti($flushItems);
    }

    private function getKeyFromAdapterKey($adapterKey)
    {
        return str_replace($this->namespace . '-', '', $adapterKey);
    }

    private function getAdapterKey($key)
    {
        return $this->namespace . '-' . $key;
    }

}