<?php

namespace IssetBv\CacheBundle\Framework\Adapter;

use \Memcached as MemcachedCore;

class Memcached implements Adapter
{

    /**
     *  @var \Memcached 
     */
    private $memcached;

    public function __construct($connection, $port = 11211)
    {
        if ($connection instanceof MemcachedCore) {
            $this->memcached = $connection;
        } else if (is_array($connection)) {
            $this->memcached = new MemcachedCore();
            foreach($connection as $connectionData){
                $this->memcached->addServer($connectionData['ip'], $connectionData['port']);
            }
        } else {
            
            $this->memcached->addServer($connection, $port);
        }
    }

    public function setMulti(array $items, $expiration = null)
    {
        return $this->memcached->setMulti($items, $expiration);
    }

    public function getMulti($keys)
    {
        return $this->memcached->getMulti($keys);
    }

    public function set($key, $value, $expiration = null)
    {
        return $this->memcached->set($key, $value, $expiration);
    }

    public function get($key)
    {
        return $this->memcached->get($key);
    }

    public function delete($key)
    {
        return $this->memcached->delete($key);
    }

    public function flush()
    {
        return $this->memcached->flush();
    }

}