<?php

declare(strict_types=1);

namespace IssetBV\Date;

use DateTimeImmutable;
use DateTimeInterface;

/**
 * @author Tim Fennis <tim@isset.nl>
 */
final class DateTimeHelper
{
    /**
     * @param DateTimeInterface $dateTimeInterface
     *
     * @return DateTimeImmutable
     */
    final public static function toImmutable(DateTimeInterface $dateTimeInterface)
    {
        return new DateTimeImmutable($dateTimeInterface->format(DATE_W3C));
    }
}
