<?php

declare(strict_types=1);

namespace IssetBV\Date;

use DateTime;
use DateTimeImmutable;
use PHPUnit\Framework\TestCase;

class DateTimeHelperTest extends TestCase
{
    /**
     * @test
     */
    public function it_should_return_an_identical_immutable()
    {
        $mutable = new DateTime('January 31 1991');
        $immutable = DateTimeHelper::toImmutable($mutable);

        TestCase::assertInstanceOf(DateTimeImmutable::class, $immutable);
        TestCase::assertEquals($mutable->format('c'), $immutable->format('c'));
    }
}
