<?php

declare(strict_types=1);

namespace IssetBV\Util;

use IssetBV\Util\Func\SimFunction;

/**
 * Class F.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class F
{
    /**
     * @param string $function
     *
     * @return mixed
     */
    public static function mapper(string $function): callable
    {
        return new class($function) implements SimFunction {
            /**
             * @var string
             */
            private $function;

            /**
             *  constructor.
             *
             * @param string $function
             */
            public function __construct($function)
            {
                $this->function = $function;
            }

            public function __invoke()
            {
                return $this->apply(func_get_args()[0]);
            }

            /**
             * @param mixed $t
             *
             * @return mixed
             */
            public function apply($t)
            {
                if (false === is_object($t)) {
                    throw new \RuntimeException('Cannot create mapper for ' . gettype($t));
                }

                if (false === method_exists($t, $this->function)) {
                    throw new \RuntimeException('Cannot create mapper for ' . get_class($t) . '::' . $this->function);
                }

                return $t->{$this->function}();
            }
        };
    }
}
