<?php

declare(strict_types=1);

namespace IssetBV\Util;

use IssetBV\Util\Func\SimFunction;
use IssetBV\Util\Test\Wrapper;
use PHPUnit\Framework\TestCase;

/**
 * Class FTest.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class FTest extends TestCase
{
    /**
     * @test
     */
    public function it_should_create_a_valid_mapper()
    {
        TestCase::assertInstanceOf(SimFunction::class, F::mapper('unwrap'));

        $optional = Optional::of(new Wrapper('test'));
        $value = $optional->map(F::mapper('unwrap'));

        TestCase::assertEquals('test', $value->orElse('not-test'));
    }
}
