<?php

declare(strict_types=1);

namespace IssetBV\Util;

use ArrayAccess;
use IssetBV\Util\Exception\UnsupportedOperationException;

/**
 * Interface OrderedCollection.
 *
 *
 * @todo I want to name this List but PHP is a bitch
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface OrderedCollection extends Collection, ArrayAccess
{
    /**
     * Replaces the element at the specified position in this list with the specified element (optional operation).
     *
     * @param int $index
     * @param mixed $element
     *
     * @throws UnsupportedOperationException
     *
     * @return bool
     */
    public function set(int $index, $element): bool;

    /**
     * Inserts all of the elements in the specified collection into this list at the specified position (optional operation).
     *
     * @param int $index
     * @param Collection $collection
     *
     * @throws UnsupportedOperationException
     *
     * @return bool
     */
    public function insertAll(int $index, Collection $collection): bool;

    /**
     * Returns the element at the specified position in this list.
     *
     * @param int $index
     *
     * @return mixed
     */
    public function get(int $index);

    /**
     * Returns the index of the first occurrence of the specified element in this list, or -1 if this list does not contain the element.
     *
     * @param $element
     *
     * @return int
     */
    public function indexOf($element): int;

    /**
     * Returns the index of the last occurrence of the specified element in this list, or -1 if this list does not contain the element.

     * @param $element
     *
     * @return int
     */
    public function lastIndexOf($element): int;

    /**
     * Removes the element at the specified position in this list (optional operation).
     *
     * @param int $index
     *
     * @throws UnsupportedOperationException
     *
     * @return bool
     */
    public function remove(int $index): bool;

    /**
     * Replaces each element of this list with the result of applying the operator to that element.

     * @param callable $operator
     *
     * @throws UnsupportedOperationException
     */
    public function replaceAll(callable $operator);

    /**
     * Sorts this list according to the order induced by the specified Comparator.
     *
     * @param callable $comparator
     */
    public function sort(callable $comparator);

    /**
     * Returns a view of the portion of this list between the specified fromIndex, inclusive, and toIndex, exclusive.

     * @param int $fromIndex
     * @param int $toIndex
     *
     * @return OrderedCollection
     */
    public function subList(int $fromIndex, int $toIndex): OrderedCollection;
}
