<?php

declare(strict_types=1);

namespace IssetBV\Util;

use IssetBV\Util\Func\SimFunction;

/**
 * Class F.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class F
{
    /**
     * @param string $string
     *
     * @return mixed
     */
    public static function mapper(string $string): callable
    {
        return new class($string) implements SimFunction {
            /**
             * @var string
             */
            private $function;

            /**
             *  constructor.
             *
             * @param string $function
             */
            public function __construct($function)
            {
                $this->function = $function;
            }

            public function __invoke()
            {
                return call_user_func_array([$this, 'apply'], func_get_args());
            }

            /**
             * @param mixed $t
             *
             * @return mixed
             */
            public function apply($t)
            {
                if (false === is_object($t)) {
                    throw new \InvalidArgumentException('Cannot create mapper for ' . gettype($t));
                }

                if (false === method_exists($t, $this->function)) {
                    throw new \InvalidArgumentException('Cannot create mapper for ' . get_class($t) . '::' . $this->function);
                }

                return call_user_func([$t, $this->function]);
            }
        };
    }
}
