<?php

declare(strict_types=1);

namespace IssetBV\Doctrine\Repository;

use IssetBV\Util\Optional;

/**
 * You can use this trait to decorate your EntityRepository with a couple of methods that return optionals!
 *
 * @author Tim Fennis <tim@isset.nl>
 */
trait OptionalRepository
{
    /* implemented by entity repository */
    abstract public function find($id, $lockMode = null, $lockVersion = null);

    /* implemented by entity repository */
    abstract public function findOneBy(array $criteria, array $orderBy = null);

    /**
     * @param mixed $id
     * @param int|null $lockMode
     * @param int|null $lockVersion
     *
     * @return Optional
     */
    public function optionallyFind($id, $lockMode = null, $lockVersion = null): Optional
    {
        return Optional::of($this->find($id, $lockMode, $lockVersion));
    }

    /**
     * Finds a single entity by a set of criteria.
     *
     * @param array $criteria
     * @param array|null $orderBy
     *
     * @return Optional The entity wrapped in an Optional
     */
    public function optionallyFindOneBy(array $criteria, array $orderBy = null): Optional
    {
        return Optional::of($this->findOneBy($criteria, $orderBy));
    }
}
