<?php

declare(strict_types=1);

namespace IssetBV\Util;

use IssetBV\Util\Exception\UnsupportedOperationException;

/**
 * Class ImmutableAbstractCollection.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
abstract class ImmutableCollection implements Collection
{
    final public function add($element): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function addAll(Collection $collection): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function clear()
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function removeElement($object): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function removeAll(Collection $collection): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function removeIf(callable $filter): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function retainAll(Collection $collection): bool
    {
        throw new UnsupportedOperationException(__METHOD__ . ' is not supported because this collection is immutable.');
    }

    final public function count()
    {
        return $this->size();
    }
}
