<?php
declare(strict_types = 1);

namespace IssetBV\Util\Func;

/**
 * Interface SimFunction.
 *
 * This interface would be called Function if that name was available in PHP. Sim, according to
 * wikipedia, is found in the words simplex and simple and is the singular version of the bi- prefix used in BiFunction.
 *
 *
 * @internal Until functional interfaces become a thing in PHP
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface SimFunction // <T,R>
{
    /**
     * @param T $t
     * @return R
     */
    public function apply($t);
}