<?php
declare(strict_types = 1);

namespace IssetBV\Twig;

use Twig_Error_Syntax;
use Twig_Node;
use Twig_Node_Expression_Array;
use Twig_Node_Expression_Constant;
use Twig_Node_Expression_GetAttr;
use Twig_Node_Expression_Name;
use Twig_NodeInterface;
use Twig_Token;
use Twig_TokenParser;

/**
 * Class OptionalTokenParser.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class OptionalTokenParser extends Twig_TokenParser
{
    /**
     * Parses a token and returns a node.
     *
     * @param Twig_Token $token A Twig_Token instance
     *
     * @throws Twig_Error_Syntax
     *
     * @return Twig_NodeInterface A Twig_NodeInterface instance
     */
    public function parse(Twig_Token $token)
    {
        /** @var mixed $lineno */
        $lineno = $token->getLine();
        $parser = $this->parser;
        $stream = $parser->getStream();

        $optionalToken = $stream->expect(Twig_Token::NAME_TYPE);

        $stream->expect(Twig_Token::BLOCK_END_TYPE);

        $originalBody = $this->parser->subparse(
            function (Twig_Token $token) {
                return $token->test('endoptional');
            }
        );

        $optionalExpression = new Twig_Node_Expression_GetAttr(
            new Twig_Node_Expression_Name($optionalToken->getValue(), $lineno),
            new Twig_Node_Expression_Constant('isPresent', $lineno),
            new Twig_Node_Expression_Array([], $lineno),
            'method',
            $lineno
        );

        $body = [$this->__do_set_magic($optionalToken, $lineno)];

        foreach ($originalBody as $originalBodyNode) {
            $body[] = $originalBodyNode;
        }

        $tests = [$optionalExpression, new Twig_Node($body)];

        $stream->expect(Twig_Token::NAME_TYPE);
        $stream->expect(Twig_Token::BLOCK_END_TYPE);

        return new OptionalNode(new Twig_Node($tests), null, $lineno, $this->getTag());
    }

    /**
     * Gets the tag name associated with this token parser.
     *
     * @return string The tag name
     */
    public function getTag()
    {
        return 'optional';
    }

    /**
     * @param $optionalToken
     * @param $lineno
     *
     * @return \Twig_Node_Set
     */
    protected function __do_set_magic($optionalToken, $lineno)
    {
        return new \Twig_Node_Set(
            false,
            new \Twig_Node_Expression_AssignName($optionalToken->getValue(), $lineno),
            new \Twig_Node_Expression_GetAttr(
                new Twig_Node_Expression_Name($optionalToken->getValue(), $lineno),
                new Twig_Node_Expression_Constant('orElse', $lineno),
                new Twig_Node_Expression_Array([
                    new Twig_Node_Expression_Constant(0, $lineno),
                    new Twig_Node_Expression_Constant(null, $lineno),
                ], $lineno),
                'method',
                $lineno
            ),
            $lineno,
            $this->getTag()
        );
    }
}
