<?php

namespace Mediator\Placing;

use Mediator\Placing\PlacingData\RegisterPlacingData;
use Mediator\Placing\PlacingData\UpdatePlacingData;
use Mediator\Helper\PreparerInterface;

class Placing extends AbstractPlacing {
	
	public function update(array $data)
	{
		$placing_data = new UpdatePlacingData($data);

		if ( ! $placing_data->isValid())
		{
			throw new \Exception('Missing data');
		}
		else
		{
			return $this->client->update($placing_data);
		}
	}
	
	public function create(array $data, PreparerInterface $preparer)
	{
		$placing_data = new RegisterPlacingData($data, $preparer);

		if ( ! $placing_data->isValid())
		{
			throw new \Exception('Missing data');
		}
		else
		{
			return $this->client->register($placing_data);
		}
	}
	
	public function get($placing_id)
	{
		return $this->client->getById($placing_id);
	}
	
}
