<?php

namespace Mediator\Helper;

class Preparer implements PreparerInterface {
	
	protected $prefix;
	protected $environment;
	
	public function __construct($prefix, $environment)
	{
		$this->prefix = $prefix;
		$this->environment = $environment;
	}
	
	/**
	 * Take an asset_id and prefix it, and suffixes it if it is not running on the Production 
	 * environment. This prevents actual overwrites on a LIVE environment
	 * 
	 * @param string $asset_id
	 * @return string
	 */
	public function asset($asset_id)
	{
		$pos = strpos(strtolower($asset_id), strtolower($this->prefix));

		$asset_id = ($pos === FALSE) ? $this->prefix . $asset_id : $asset_id;

		if ($this->environment !== 'production')
		{
            $environment = ($this->environment == "testing") ? "TEST" : "DEV";
			$pos = strpos($asset_id, $environment);

			$asset_id = ($pos === FALSE) ? $asset_id . '-' . $environment : $asset_id;
		}

		return mb_convert_case($asset_id, MB_CASE_UPPER);
	}
	
	/**
	 * Take a string or array of ISO audio languages and prepare them for Mediator
	 * 
	 * @param string|array $audio
	 * @return array
	 */
	public function audio_lang($audio)
	{
		$iso = (is_array($audio)) ? $audio : array($audio);
		$data = array();

		foreach ($iso as $code)
		{
			$data[]['Code'] = $code;
		}

		return $data;
	}
	
	
	/**
	 * Take a string or array of ISO subtitles languages and prepare them for Mediator
	 * 
	 * @param string|array $audio
	 * @return array
	 */
	public function sub_lang($subs)
	{
		$iso = (is_array($subs)) ? $subs : array($subs);
		$data = array();

		foreach ($iso as $code)
		{
			$data[]['Code'] = $code;
		}

		return $data;
	}
}