<?php

namespace Mediator\Placing\PlacingData;

class UpdatePlacingData extends AbstractPlacingData{

	private $id;
	private $name;
	private $description;
	
	private $required_fields = array('id', 'window_start', 'window_end');
	
	public function __construct(array $data)
	{
		foreach ($data as $key => $value)
		{
			if (property_exists($this, $key))
			{
				$this->$key = $value;
			}
		}
		
		parent::__construct($data);
	}
	
	public function isValid()
	{
		foreach ($this->required_fields as $field)
		{
			if (is_null($this->$field))
			{
				return FALSE;
			}
			
			return TRUE;
		}
	}
	
	public function __get($key)
	{
		if (isset($this->$key))
		{
			return $this->$key;
		}
	}
}