<?php

namespace Mediator\Placing\PlacingData;

interface RegisterPlacingDataInterface {

	/**
	 * @return int Asset_Id
	 */
	public function getId();
	
	/**
	 * @return string Placing Profile
	 */
	public function getPublishProfile();
	
	/**
	 * @return string Window Start
	 */
	public function getWindowStart();
	
	/**
	 * @return string Window End
	 */
	public function getWindowEnd();
	
	/**
	 * @return string Asset Name
	 */
	public function getName();
	
	/**
	 * @return string Asset Description
	 */
	public function getDescription();
	
	/**
	 * @return array Asset Audio Languages
	 */
	public function getAudioLanguages();
	
	/**
	 * @return bool Preview
	 */
	public function hasPreview();
}
