<?php

namespace Mediator\Placing\PlacingData;

use Mediator\Helper\PreparerInterface;

class RegisterPlacingData extends AbstractPlacingData implements RegisterPlacingDataInterface {

	protected $asset_id;
	protected $name;
	protected $description;
	protected $publish_profile;
	protected $subtitle_languages = array();
	protected $audio_languages = array();
	protected $preview = FALSE;

	protected $_preparer;
	protected $_required_fields = array('asset_id', 'window_start', 'window_end', 'publish_profile', 'audio_languages');
	
	public function __construct(array $data, PreparerInterface $preparer)
	{
		foreach ($data as $key => $value)
		{
			if (property_exists($this, $key) AND substr($key, 0, 1) != '_')
			{
				$this->$key = $value;
			}
		}
		
		$this->_preparer = $preparer;
		
		parent::__construct($data);
	}
	
	/**
	 * Checks if all the required fields are there
	 * 
	 * @return boolean
	 */
	public function isValid()
	{
		foreach ($this->_required_fields as $field)
		{
			if (is_null($this->$field))
			{
				return FALSE;
			}
			
			return TRUE;
		}
	}

	public function getId()
	{
		return $this->_preparer->asset($this->asset_id);
	}
	
	public function getPublishProfile()
	{
		return $this->publish_profile;
	}
	
	public function getAudioLanguages()
	{
		return $this->_preparer->audio_lang($this->audio_languages);
	}

	public function getDescription()
	{
		return $this->description;
	}

	public function getName()
	{
		return $this->name;
	}

	public function hasPreview()
	{
		return $this->_preparer->preview($this->preview, $this->publish_profile);
	}
}
