<?php

namespace Mediator\Placing\PlacingData;

abstract class AbstractPlacingData {
	
	protected $window_start;
	protected $window_end;
		
	public function __construct(array $placing_data)
	{
		if ($placing_data['window_start'])
		{
			$this->setWindowStart($placing_data['window_start']);
		}
		
		if ($placing_data['window_end'])
		{
			$this->setWindowEnd($placing_data['window_end']);
		}
	}
	
	public function getWindowStart()
	{
		return $this->window_start->format('Y-m-d\TH:i:s');
	}
	
	protected function setWindowStart($window_start)
	{
		try
		{
			if ( ! $window_start instanceof \DateTime)
			{
				$window_start = new \DateTime($window_start);
			}
			$datetimezone = new \DateTimeZone('UTC');
			$this->window_start = $window_start->setTimezone($datetimezone);
		}
		catch(\Exception $e)
		{
			// invalid DateTime object so we let is_valid() fail
			$this->window_start = NULL;
		}
	}
	
	public function getWindowEnd()
	{
		return $this->window_end->format('Y-m-d\TH:i:s');;
	}

	protected function setWindowEnd($window_end)
	{
		try
		{
			if ( ! $window_end instanceof \DateTime)
			{
				$window_end = new \DateTime($window_end);
			}
			$datetimezone = new \DateTimeZone('UTC');
			$this->window_end = $window_end->setTimezone($datetimezone);
		}
		catch(\Exception $e)
		{
			// invalid DateTime object so we let is_valid() fail
			$this->window_end = NULL;
		}
	}
	
	abstract public function isValid();
}
