<?php

namespace Mediator\Placing;

use Mediator\Client\PlacingInterface;
use Mediator\Helper\PreparerInterface;

abstract class AbstractPlacing {
	
	protected $client;
	
	public function __construct(PlacingInterface $client)
	{
		$this->client = $client;
	}
	
	abstract public function update(array $data);
	abstract public function create(array $data, PreparerInterface $preparer);
	abstract public function get($placing_id);
	
	protected function getClient()
	{
		return $this->client;
	}
}