<?php

if (class_exists('Monolog\Logger')) {

    /**
     * Overwrites the default logger for codeigniter to logger that send data to the graylog2 server
     *
     * @staticvar Monolog\Logger $logger
     */
    function log_message($level, $message)
    {
        static $logger  = null;
        static $helpers = null;

        //check if logging is on
        if (config_item('log_threshold') == 0) {
            return;
        }


        $config = config_item('log_gelf'); //get the log gelf config
        if (!empty($config)) {

            if ($helpers === null) {
                $helpers = array();
                if (!empty($config['levels']) && is_array($config['levels'])) {
                    foreach ($config['levels'] as $logLevel) {
                        $helpers[strtoupper($logLevel['level'])] = $logLevel;
                    }
                }
            }


            if (empty($logger)) { //Check if there is allready a logger class initialized
                $publisher = new Gelf\MessagePublisher($config['ip'], $config['port']); // make a gelf message publisher
                $handler   = new Monolog\Handler\GelfHandler($publisher); //make a new gelf handler
                $logger    = new Monolog\Logger($config['name']); // make a new mono logger
                $logger->pushHandler($handler); //add handler to the logger
            }

            $level  = strtoupper($level); //turn uppercase for check
            $levels = array('ERROR' => '1', 'DEBUG' => '2', 'INFO' => '3', 'ALL' => '4'); // codeigniter log levels
            if (isset($levels[$level]) && $levels[$level] <= config_item('log_threshold')) { // check if the current log threshold may send to the graylog server
                switch ($level) { //send message based on level
                    case 'ERROR':
                        $logger->addError($message);
                        break;
                    case 'DEBUG':
                        $logger->addDebug($message);
                        break;
                    case 'INFO':
                    case 'ALL':
                    default:
                        $logger->addInfo($message);
                        break;
                }
            } else if (!empty($helpers[$level])) {
                if (empty($helpers[$level]['logger'])) {
                    $publisher                 = new Gelf\MessagePublisher($helpers[$level]['ip'], $helpers[$level]['port']); // make a gelf message publisher
                    $handler                   = new Monolog\Handler\GelfHandler($publisher); //make a new gelf handler
                    $helpers[$level]['logger'] = new Monolog\Logger($helpers[$level]['name']); // make a new mono logger
                    $helpers[$level]['logger']->pushHandler($handler); //add handler to the logger
                }


                $configLevel = isset($helpers[$level]['type']) ? strtoupper($helpers[$level]['type']) : '';
                switch ($configLevel) { //send message based on level
                    case 'ERROR':
                        $helpers[$level]['logger']->addError($message);
                        break;
                    case 'DEBUG':
                        $helpers[$level]['logger']->addDebug($message);
                        break;
                    case 'INFO':
                    case 'ALL':
                    default:
                        $helpers[$level]['logger']->addInfo($message);
                        break;
                }
            }
        }
    }

}