<?php
namespace Alfredo\Payload\Pdf\Stamp;

abstract class Stamp implements StampInterface
{

    protected $pages;

    protected $type;

    protected $positionAlign;

    protected $positionX;

    protected $positionY;

    protected $positionXType;

    protected $positionYType;

    public function __construct(array $pages, $positionX, $positionY)
    {
        $this->pages = $pages;
        $this->type = 1;
        $this->positionAlign = 'bl';
        $this->positionX = $positionX;
        $this->positionY = $positionY;
    }

    public function setPositionAlign($align)
    {
        $this->positionAlign = $align;
    }

    public function toArray()
    {
        return [
            'pages' => $this->pages,
            'type' => $this->type,
            'positionAlign' => $this->positionAlign,
            'positionX' => $this->positionX,
            'positionY' => $this->positionY,
            'positionXType' => $this->positionXType,
            'positionYType' => $this->positionYType
        ];
    }

    public function setPositionXType($positionXType)
    {
        $this->positionXType = $positionXType;
    }

    public function setPositionYType($positionYType)
    {
        $this->positionYType = $positionYType;
    }
}