<?php

namespace Alfredo\Payload\Pdf;

use Alfredo\Payload\PayloadAbstract;

class Convert extends PayloadAbstract
{

    public function __construct()
    {
        $this->setConverter('htmltopdfjava');
        $this->setSetting('packer', 'pdftk');
    }

    public function addStamp(Stamp\StampInterface $stampInterface)
    {
        if (!$this->hasSetting('stamp')) {
            $this->setSetting('stamp', array());
        }
        $stamp = $this->getSetting('stamp');
        $stamp[] = $stampInterface->toArray();
        $this->setSetting('stamp', $stamp);
    }

    public function addHtmlFile($file, array $options = array())
    {
        if (!isset($options['htmlentities'])) {
            $options['htmlentities'] = true;
        }
        $fileName = uniqid('file_', false);
        $this->addFile($fileName, $file);
        return $this->addDataFile($fileName, 'html', $options);
    }

    /**
     * @param string $html
     * @param array $options
     * @return Convert
     */
    public function addHtml($html, array $options = array())
    {
        if (!isset($options['htmlentities'])) {
            $options['htmlentities'] = true;
        }
        return $this->addData($html, 'html', $options);
    }

    /**
     * @param string $file
     * @param array $options
     * @return Convert
     */
    public function addImageFile($file, array $options = array())
    {
        $options['converter'] = 'imagetopdf';

        $fileName = uniqid('file_', false);
        $this->addFile($fileName, $file);
        return $this->addDataFile($fileName, 'pdf', $options);
    }

    /**
     * @param string $data
     * @param array $options
     * @return Convert
     */
    public function addImage($data, array $options = array())
    {
        if (empty($options['encoding'])) {
            $options['encoding'] = 'base64';
            $data = base64_encode($data);
        }
        $options['converter'] = 'imagetopdf';
        return $this->addData($data, 'image', $options);
    }

    /**
     *
     * @param string $url
     * @param array $options
     * @return Convert
     */
    public function addUrl($url, array $options = array())
    {
        return $this->addData($url, 'url', $options);
    }

    /**
     *
     * @param string $data
     * @param array $options
     * @return Convert
     */
    public function addPdf($data, array $options = array())
    {
        if (empty($options['encoding'])) {
            $options['encoding'] = 'base64';
            $data = base64_encode($data);
        }

        if (empty($options['converter'])) {
            $options['converter'] = false;
        }
        return $this->addData($data, 'pdf', $options);
    }

    /**
     *
     * @param string $file
     * @param array $options
     * @return Convert
     */
    public function addPdfFile($file, array $options = array())
    {

        if (empty($options['converter'])) {
            $options['converter'] = false;
        }

        $fileName = uniqid('file_', false);
        $this->addFile($fileName, $file);
        return $this->addDataFile($fileName, 'pdf', $options);
    }

    public function getType()
    {
        return 'pdf';
    }

}