<?php

namespace Alfredo\Payload;

abstract class PayloadAbstract
{

    protected $payload = array();

    abstract function getType();

    public function addData($data, $type, $options = array())
    {
        $this->payload['data'][] = array('data' => $data, 'type' => $type, 'options' => $options);
        return $this;
    }

    public function addDataFile($data, $type, $options = array())
    {
        $this->payload['data'][] = array('data' => $data, 'type' => $type, 'file' => true, 'options' => $options);
        return $this;
    }

    public function addFile($name, $file)
    {
        if (function_exists('curl_file_create')) {
            $this->payload[$name] = curl_file_create($file);
        } else {
            $this->payload[$name] = '@' . $file;
        }

    }

    public function setSetting($setting, $value)
    {
        $this->payload[$setting] = $value;
        return $this;
    }

    public function hasSetting($setting)
    {
        return isset($this->payload[$setting]);
    }

    public function getSetting($setting)
    {
        return $this->payload[$setting];
    }

    public function getPayload()
    {
        return $this->payload;
    }

    public function addIdentifier($identifier, array $options = array())
    {
        $this->addData($identifier, 'identifier', $options);
        return $this;
    }

    /**
     *
     * @param string $url
     * @return Convert
     */
    public function setCallBack($url)
    {
        return $this->setSetting('callback', $url);
    }

    /**
     *
     * @param string $converter
     * @return Convert
     */
    public function setConverter($converter)
    {
        return $this->setSetting('converter', $converter);
    }

}
