<?php
namespace Alfredo\Payload\Pdf\Stamp;

class StampText extends Stamp
{

    protected $fontType;

    protected $fontSize;

    protected $text;

    protected $r;

    protected $g;

    protected $b;

    protected $link;

    protected $opaticy;

    public function __construct(array $pages, $positionX, $positionY, $fontType, $fontSize, $text, $r, $g, $b, $link = null)
    {
        parent::__construct($pages, $positionX, $positionY);
        $this->fontType = $fontType;
        $this->fontSize = $fontSize;
        $this->text = $text;
        $this->r = $r;
        $this->g = $g;
        $this->b = $b;
        $this->link = $link;
    }

    public function setOpaticy($opaticy)
    {
        $this->opaticy = $opaticy;
    }

    public function toArray()
    {
        return array_merge(parent::toArray(), [
            'stamp_type' => 'text',
            'fontType' => $this->fontType,
            'fontSize' => $this->fontSize,
            'text' => $this->text,
            'r' => $this->r,
            'g' => $this->g,
            'b' => $this->b,
            'link' => $this->link,
            'opaticy' => $this->opaticy
        ]);
    }
}