<?php
namespace Alfredo\Payload\Pdf\Stamp;

class StampShapeSquare extends Stamp
{

    protected $width;

    protected $widthType;

    protected $height;

    protected $heightType;

    protected $r;

    protected $g;

    protected $b;

    protected $opaticy;

    public function __construct(array $pages, $positionX, $positionY, $width, $height, $r, $g, $b)
    {
        parent::__construct($pages, $positionX, $positionY);
        $this->width = $width;
        $this->height = $height;
        $this->r = $r;
        $this->g = $g;
        $this->b = $b;
    }

    public function toArray()
    {
        return array_merge(parent::toArray(), [
            'stamp_type' => 'shape_square',
            'width' => $this->width,
            'height' => $this->height,
            'r' => $this->r,
            'g' => $this->g,
            'b' => $this->b,
            'opaticy' => $this->opaticy,
            'widthType' => $this->widthType,
            'heightType' => $this->heightType
        ]);
    }

    public function setWidthType($widthType)
    {
        $this->widthType = $widthType;
    }

    public function setHeightType($heightType)
    {
        $this->heightType = $heightType;
    }

    public function setOpaticy($opaticy)
    {
        $this->opaticy = $opaticy;
    }
}
