<?php

namespace Alfredo\Payload\Pdf\Stamp;

abstract class Stamp implements StampInterface
{

    protected $pages;
    protected $type;
    protected $positionAlign;
    protected $positionX;
    protected $positionY;

    public function __construct(array $pages, $positionX, $positionY)
    {
        $this->pages         = $pages;
        $this->type          = 1;
        $this->positionAlign = 'bl';
        $this->positionX     = $positionX;
        $this->positionY     = $positionY;
    }

    public function setPositionAlign($align)
    {
        $this->positionAlign = $align;
    }

    public function toArray()
    {
        return [
            'pages' => $this->pages,
            'type' => $this->type,
            'positionAlign' => $this->positionAlign,
            'positionX' => $this->positionX,
            'positionY' => $this->positionY
        ];
    }

}