<?php

namespace Alfredo\Payload\Pdf\Stamp;

class StampImage extends Stamp
{

    protected $source;
    protected $width;
    protected $height;

    public function __construct(array $pages, $positionX, $positionY, $source, $width, $height)
    {
        parent::__construct($pages, $positionX, $positionY);
        $this->source = $source;
        $this->width  = $width;
        $this->height = $height;
    }

    public function toArray()
    {
        return array_merge(parent::toArray(), [
                    'stamp_type' => 'image',
                    'source' => $this->source,
                    'width' => $this->width,
                    'height' => $this->height
                        ]
        );
    }

}