<?php

namespace Alfredo\Payload\Pdf\Stamp;

class StampText extends Stamp
{

    protected $fontType;
    protected $fontSize;
    protected $text;
    protected $r;
    protected $g;
    protected $b;

    public function __construct(array $pages, $positionX, $positionY, $fontType, $fontSize, $text, $r, $g, $b)
    {
        parent::__construct($pages, $positionX, $positionY);
        $this->fontType = $fontType;
        $this->fontSize = $fontSize;
        $this->text     = $text;
        $this->r        = $r;
        $this->g        = $g;
        $this->b        = $b;
    }

    public function toArray()
    {
        return array_merge(parent::toArray(), [
                    'stamp_type' => 'text',
                    'fontType' => $this->fontType,
                    'fontSize' => $this->fontSize,
                    'text' => $this->text,
                    'r' => $this->r,
                    'g' => $this->g,
                    'b' => $this->b
                        ]
        );
    }

}