<?php

namespace Alfredo\Payload\Pdf\Stamp;

abstract class Stamp implements StampInterface
{

    protected $pages;
    protected $type;
    protected $positionX;
    protected $positionY;

    public function __construct(array $pages, $positionX, $positionY)
    {
        $this->pages     = $pages;
        $this->type      = 1;
        $this->positionX = $positionX;
        $this->positionY = $positionY;
    }

    public function toArray()
    {
        return [
            'pages' => $this->pages,
            'type' => $this->type,
            'positionX' => $this->positionX,
            'positionY' => $this->positionY
        ];
    }

}